#pragma once


#ifdef SSCOMM_EXPORTS
#define SSCOMM_CODEC_API __declspec(dllexport)
#else
#define SSCOMM_CODEC_API __declspec(dllimport)
#endif

#ifdef __cplusplus
extern "C" {
#endif

	SSCOMM_CODEC_API int SosenProgrammerCodecBuildGetIadjust(
		/*OUT*/char* lpOutputBuffer, /*IN,OUT*/int* lpnOutputSize);
	SSCOMM_CODEC_API int SosenProgrammerCodecDecodeGetIadjust(
		/*mA*/int* lpnIadjust, /*mA*/int nImax, /*IN*/char* lpInputBuffer, /*IN*/int nInputSize);
	SSCOMM_CODEC_API int SosenProgrammerCodecBuildSetIadjust(
		/*mA*/int nIadjust, /*mA*/int nImax, /*OUT*/char* lpOutputBuffer, /*IN,OUT*/int* lpnOutputSize);
	SSCOMM_CODEC_API int SosenProgrammerCodecDecodeSetIadjust(
		/*mA*/int nIadjust, /*mA*/int nImax, /*IN*/char* lpInputBuffer, /*IN*/int nInputSize);

	SSCOMM_CODEC_API int SosenProgrammerCodecBuildGetIset(
		/*OUT*/char* lpOutputBuffer, /*IN,OUT*/int* lpnOutputSize);
	SSCOMM_CODEC_API int SosenProgrammerCodecDecodeGetIset(
		/*mA*/int* lpnIset, /*mA*/int nImax, /*IN*/char* lpInputBuffer, /*IN*/int nInputSize);
	SSCOMM_CODEC_API int SosenProgrammerCodecBuildSetIset(
		/*mA*/int nIset, /*mA*/int nImax, /*OUT*/char* lpOutputBuffer, /*IN,OUT*/int* lpnOutputSize);
	SSCOMM_CODEC_API int SosenProgrammerCodecDecodeSetIset(
		/*mA*/int nIset, /*mA*/int nImax, /*IN*/char* lpInputBuffer, /*IN*/int nInputSize);

	
	SSCOMM_CODEC_API int SosenProgrammerCodecBuildGetVset(
		/*OUT*/char* lpOutputBuffer, 
		/*IN,OUT*/int* lpnOutputSize);
	SSCOMM_CODEC_API int SosenProgrammerCodecDecodeGetVset(
		/*mV*/int* lpnVset, 
		/*mV*/int nVmax, 
		/*IN*/char* lpInputBuffer, 
		/*IN*/int nInputSize);
	SSCOMM_CODEC_API int SosenProgrammerCodecBuildSetVset(
		/*mV*/int nVset, 
		/*mV*/int nVmax, 
		/*OUT*/char* lpOutputBuffer, 
		/*IN,OUT*/int* lpnOutputSize);
	SSCOMM_CODEC_API int SosenProgrammerCodecDecodeSetVset(
		/*mV*/int nVset, /*mV*/int nVmax, /*IN*/char* lpInputBuffer, /*IN*/int nInputSize);

	SSCOMM_CODEC_API int SosenProgrammerCodecBuildGetDimmingLevel(
		/*OUT*/char* lpOutputBuffer, /*IN,OUT*/int* lpnOutputSize);
	SSCOMM_CODEC_API int SosenProgrammerCodecDecodeGetDimmingLevel(
		/*0.01%*/int* lpnLevelSet, /*IN*/char* lpInputBuffer, /*IN*/int nInputSize);
	SSCOMM_CODEC_API int SosenProgrammerCodecBuildSetDimmingLevel(
		/*0.01%*/int nLevelSet, /*OUT*/char* lpOutputBuffer, /*IN,OUT*/int* lpnOutputSize);
	SSCOMM_CODEC_API int SosenProgrammerCodecDecodeSetDimmingLevel(
		/*0.01%*/int nLevelSet, /*IN*/char* lpInputBuffer, /*IN*/int nInputSize);

	SSCOMM_CODEC_API int SosenProgrammerCodecBuildGetVersion(
		/*OUT*/char* lpOutputBuffer, /*IN,OUT*/int* lpnOutputSize);
	SSCOMM_CODEC_API int SosenProgrammerCodecDecodeGetVersion(
		/**/char* lpVersion, /*IN,OUT*/int* lpnOutputSize, /*IN*/char* lpInputBuffer, /*IN*/int nInputSize);

	SSCOMM_CODEC_API int SosenProgrammerCodecBuildGetSave(
		/*OUT*/char* lpOutputBuffer, /*IN,OUT*/int* lpnOutputSize);
	SSCOMM_CODEC_API int SosenProgrammerCodecDecodeGetSave(
		/*0/1*/int* lpnSave, /*IN*/char* lpInputBuffer, /*IN*/int nInputSize);

#ifdef __cplusplus
}
#endif